 /****************************************************************
 *		sequencer.c   -  Note Sequencers
 *
 *  this modules provides the note sequencer and Envelope control 
 *	functions for the alarm notes for the IEC Medical Alert tone demo.
 *
 *
 *   Copyright(C) 2007, NXP Semiconductor
 *   All rights reserved.
 *
 ****************************************************************/
#include "LPC17xx.h"
 #include "multi_tone_gen.h"
 #include "command.h"
 #include "timer.h"

 #define LED_A       0x01		  //   For MCB2300 Test 
 #define LED_B       0x02		  //   For MCB2300 Test
 #define LED_C       0x04		  //   For MCB2300 Test
 #define LED_D       0x08		  //   For MCB2300 Test

 // define rise and fall time of tones
 #define HP_RISE		12		  //   rise time setting for high priority tones (12 = ~20ms Tr)
								  // decrease to make slower, increase to make faster
 #define HP_FALL		12		  //   fall time setting for high priority tones (12 = ~20ms Tf)
								  // decrease to make slower, increase to make faster
 #define MP_RISE		8		  // 8  rise time setting for high priority tones (8 = ~30ms Tr)
								  // decrease to make slower, increase to make faster
 #define MP_FALL		8		  // 8  fall time setting for high priority tones (8 = ~30ms Tf)
								  // decrease to make slower, increase to make faster

unsigned char active_note;
unsigned char envelope_on;	
unsigned char envelope_off;
short envelope;

unsigned char const tune_sequence [][5] = {{C4,C4,C4,C4,C4},		// general
								  			{C5,B4,A4,G4,F4},		// oxygen
								  			{C4,A4,F4,A4,F4},		// ventilation
								  			{C4,E4,G4,G4,C5},		// cardiovascular
								  			{C4,D4,E4,F4,G4},		//temperature
								  			{C5,D4,G4,C5,D4},		// drug_delivery
								  			{C4,Fsharp4,C4,C4,Fsharp4}, // perfusion
								  			{C5,C4,C4,C5,C4},		 // power_fail
								  			{E4,C4,0,0,0}};		 	// low_alarm

void TurnOnNote(void);

void init_seqencer(void)
{
 	  envelope_on = 0;
	  envelope_off = 0;
}
 void HighPriSequence (unsigned char alarm_type)
{
   switch (mscount)
   {
	  case 1:
	  	active_note = tune_sequence [alarm_type][0];  // 1rst note of sequence
	  	note_level = 170;
		TurnOnNote();	
		break;	  
	  case 145: 				 //145 ms (trise + tduration)
		note_on = 0;			 // begin decay as note turns "off"	
		break;
	  case 224:
	  	active_note = tune_sequence [alarm_type][1];  // 2nd note of sequence
	  	note_level = 255;
		TurnOnNote();
		break;
	  case 368:
	   	note_on = 0;			 // begin decay as note turns "off"	
		break;
	  case 447:
		active_note = tune_sequence [alarm_type][2];  // 3rd note of sequence
	  	note_level = 255;
		TurnOnNote();
		break;
	  case 591:
	    note_on = 0;			 // begin decay as note turns "off"	
		break;
	  case 835:
	  	active_note = tune_sequence [alarm_type][3];  // 4th note of sequence
		note_level = 255;
		TurnOnNote();
		break;
	  case 979:
	  	note_on = 0;			 // begin decay as note turns "off"	
		break;
	  case 1058:
	  	active_note = tune_sequence [alarm_type][4];  // 5th note of sequence
		note_level = 255;
		TurnOnNote();
		break;
	  case 1202:
	  	note_on = 0;			 // begin decay as note turns "off"	
		break;
		
	  case 1250:				 // allows for fall time of envelope
		if (sequence == 2)
		{
			sequence = 0;
			mscount = 0;
		}  
		break;	  			
	  case 1750:
		if (sequence == 1)	   // If this is the first time through, repeat
		{
		 	sequence++;	
		} 
		mscount = 0;
	  	break;	
   }
}


 void MedPriSequence (unsigned char alarm_type)
{
   switch (mscount)
   {
	  case 1:
	  	active_note = tune_sequence [alarm_type][0];
	  	note_level = 170;
		TurnOnNote();	
		break;
	  
	  case 221: 				 //221 ms (trise(30) + tduration(190)+ start(1))
		note_on = 0;			 // begin decay as note turns "off"	
		break;

	  case 441:
	  	active_note = tune_sequence [alarm_type][1];  // 2nd note of sequence
	  	note_level = 255;
		TurnOnNote();
		break;
	  case 661:
	   	note_on = 0;			 // begin decay as note turns "off"	
		break;
	  case 881:
		active_note = tune_sequence [alarm_type][2];  // 3rd note of sequence
	  	note_level = 255;
		TurnOnNote();
		break;
	  case 1101:
	    note_on = 0;			 // begin decay as note turns "off"	
		break;
	  case 1151:				// allows for fall time of envelope 
	  	sequence = 0;
		mscount = 0;
	}
	
}

 void LowPriSequence (unsigned char alarm_type)
{
   switch (mscount)
   {
	  case 1:
	  	active_note = tune_sequence [alarm_type][0];
	  	note_level = 170;
		TurnOnNote();	
		break;
	  
	  case 261: 				 //261 ms (trise(35) + tduration(225))
		note_on = 0;			 // begin decay as note turns "off"	
		break;

	  case 521:
	  	active_note = tune_sequence [alarm_type][1];  // 2nd note of sequence
	  	note_level = 255;
		TurnOnNote();
		break;
	  case 781:
	   	note_on = 0;			// begin decay as note turns "off"	
		break;
	  case 816:					// +Tf 
	  	sequence = 0;
		mscount = 0;
	}
}

 void TestSequence (unsigned char alarm_type)
{
   switch (mscount)
   {
	  case 1:
//	  	active_note = tune_sequence [alarm_type][0];
	  	note_level = 255;
		TurnOnNote();	
		break;
	  
	  case 1000: 			
		note_on = 0;			 // begin decay as note turns "off"	
		break;

	  case 1035:
	  	sequence = 0;
		mscount = 0;
		break;
	}
}

void EnvelopeControl(void)
{
   if (note_on)
   {
   	 if (envelope >= note_level)
   	 {
	 	envelope = note_level;
     }
     else
     {
	 	if (priority == 1)
		{
			envelope += HP_RISE;		// high priority risetime control
		}
		else
		{
		 	envelope += MP_RISE;		// Medium priority risetime control
		}
     }
   }
  else 
  {
  	if (envelope >0)
   	{
	  if (priority == 1)
		{
			envelope -= HP_FALL;		 // high priority falltime control
		}
		else
		{
		 	envelope -= MP_FALL;		// Medium priority falltime control
		}
   	}
  }
  if ((envelope <= 0)&& (note_on == 0)&& (envelope_on == 1) )
  {
	  envelope = 0;
	  envelope_off = 1;	 			// synchronize with zero cross

  }
}

void TurnOnNote(void)
{
	envelope = 0;		  
	note_on = 1;
	envelope_on = 1;
}
